{{-- Bank Transfer Plugin Custom Configuration View --}}
{{-- Available variables: $config (array), $pluginName (string), $pluginSlug (string) --}}

{{-- Instructions Section --}}
<div class="mb-6">
    <div class="p-4 mb-4 text-sm text-blue-800 rounded-lg bg-blue-50 dark:bg-gray-800 dark:text-blue-400" role="alert">
        <div class="flex">
            <svg class="flex-shrink-0 inline w-4 h-4 mr-3 mt-0.5" aria-hidden="true" xmlns="http://www.w3.org/2000/svg" fill="currentColor" viewBox="0 0 20 20">
                <path d="M10 .5a9.5 9.5 0 1 0 9.5 9.5A9.51 9.51 0 0 0 10 .5ZM9.5 4a1.5 1.5 0 1 1 0 3 1.5 1.5 0 0 1 0-3ZM12 15H8a1 1 0 0 1 0-2h1v-3H8a1 1 0 0 1 0-2h2a1 1 0 0 1 1 1v4h1a1 1 0 0 1 0 2Z"/>
            </svg>
            <div>
                <span class="font-medium">{{ __('admin.payment_gateways.bank_transfer.manual_approval_title') }}</span>
                <p class="mt-1">{{ __('admin.payment_gateways.bank_transfer.manual_approval_description') }} <a href="{{ route('admin.transactions') }}" wire:navigate class="underline hover:no-underline">{{ __('admin.payment_gateways.bank_transfer.transactions_link') }}</a>.</p>
            </div>
        </div>
    </div>

    <h4 class="mb-3 text-sm font-semibold text-gray-900 dark:text-white">{{ __('admin.payment_gateways.bank_transfer.instructions_title') }}</h4>

    {{-- Instructions Textarea --}}
    <div class="mb-4">
        <label for="instructions" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">
            {{ __('admin.payment_gateways.bank_transfer.instructions_label') }}
            <span class="text-red-500">*</span>
        </label>
        <textarea
            id="instructions"
            wire:model="config.instructions"
            rows="10"
            class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 dark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500"
            placeholder="{{ __('admin.payment_gateways.bank_transfer.instructions_placeholder') }}"></textarea>
        <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
            {{ __('admin.payment_gateways.bank_transfer.instructions_help') }}
        </p>
        @error('config.instructions')
            <p class="mt-1 text-sm text-red-600 dark:text-red-500">{{ $message }}</p>
        @enderror
    </div>
</div>

{{-- Workflow Information --}}
<div class="p-4 mb-4 text-sm text-gray-800 rounded-lg bg-gray-50 dark:bg-gray-800 dark:text-gray-300" role="alert">
    <h5 class="mb-2 font-semibold">{{ __('admin.payment_gateways.bank_transfer.workflow_title') }}</h5>
    <ol class="list-decimal list-inside space-y-1 ml-2">
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_1') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_2') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_3') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_4') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_5') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_6') }}</li>
        <li>{{ __('admin.payment_gateways.bank_transfer.workflow_step_7') }}</li>
    </ol>
</div>

{{-- Supported Features --}}
<div class="mb-4">
    <h4 class="mb-2 text-sm font-semibold text-gray-900 dark:text-white">{{ __('admin.payment_gateways.features') }}</h4>
    <ul class="space-y-1 text-xs text-gray-600 dark:text-gray-400 list-disc list-inside ml-2">
        <li>✅ {{ __('admin.payment_gateways.bank_transfer.feature_currencies') }}</li>
        <li>✅ {{ __('admin.payment_gateways.bank_transfer.feature_intervals') }}</li>
        <li>✅ {{ __('admin.payment_gateways.bank_transfer.feature_simple_setup') }}</li>
        <li>✅ {{ __('admin.payment_gateways.bank_transfer.feature_manual_verification') }}</li>
        <li>✅ {{ __('admin.payment_gateways.bank_transfer.feature_no_fees') }}</li>
        <li>⚠️ {{ __('admin.payment_gateways.bank_transfer.feature_admin_approval') }}</li>
        <li>⚠️ {{ __('admin.payment_gateways.bank_transfer.feature_no_renewal') }}</li>
    </ul>
</div>
