<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ai_conversations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')->constrained()->cascadeOnDelete();
            $table->foreignId('app_id')->nullable()->constrained()->nullOnDelete();
            $table->foreignId('platform_plugin_id')->nullable()->constrained('plugins')->nullOnDelete();
            $table->string('title')->nullable();
            $table->longText('messages'); // Using longText instead of json because the model encrypts this field
            $table->string('provider')->default('openai');
            $table->string('model')->nullable();
            $table->integer('total_tokens')->default(0);
            $table->timestamps();

            $table->index(['user_id', 'updated_at']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ai_conversations');
    }
};
