<?php

return [
    // Page Titles
    'admin_overview' => 'Admin Overview',
    'overview_title' => 'Overview',
    'users_title' => 'Users',
    'subscriptions_title' => 'Subscriptions',
    'transactions_title' => 'Transactions',
    'plans_title' => 'Plans',
    'builders_title' => 'Builders',
    'plugins_title' => 'Plugins',
    'languages_title' => 'Languages',
    'cronjobs_title' => 'Cron Jobs',
    'email_templates_title' => 'Email Templates',
    'audit_logs_title' => 'Audit Logs',
    'settings_title' => 'Settings',

    // Page Subtitles
    'users_subtitle' => 'Manage platform users and accounts',
    'subscriptions_subtitle' => 'Monitor user subscriptions and billing',
    'transactions_subtitle' => 'View and manage payment transactions',
    'plans_subtitle' => 'Configure subscription plans and pricing',
    'builders_subtitle' => 'Manage builders for app compilation',
    'plugins_subtitle' => 'Manage installed plugins',
    'languages_subtitle' => 'Manage available languages',
    'cronjobs_subtitle' => 'Monitor scheduled tasks',
    'email_templates_subtitle' => 'Customize email notifications sent to users',
    'cronjobs_subtitle_full' => 'Monitor scheduled tasks and automation',
    'settings_subtitle_full' => 'Configure system-wide settings and preferences',
    'search_settings' => 'Search settings...',
    'no_settings_found' => 'No settings found matching',
    'system_settings' => 'System Settings',
    'clear_search' => 'Clear search',

    // Settings Sidebar Navigation
    'settings_section_general' => 'General',
    'settings_section_plans' => 'Plans',
    'settings_section_auth' => 'Authentication',
    'settings_section_email' => 'Email',
    'settings_section_privacy' => 'Privacy',
    'settings_section_preview' => 'Preview',
    'settings_section_ai' => 'AI Chat',
    'settings_category_platform' => 'Platform',
    'settings_category_security' => 'Security',
    'settings_category_integrations' => 'Integrations',
    'audit_logs_subtitle' => 'Track user actions and system events for GDPR compliance',
    'no_audit_logs_found' => 'No audit logs found.',
    'search_audit_logs' => 'Search by user, action, IP...',
    'date_time' => 'Date/Time',
    'actor' => 'Actor',
    'ip_address' => 'IP Address',
    'details' => 'Details',
    'view_details' => 'View Details',
    'system' => 'System',
    'clear_filters' => 'Clear filters',
    'to' => 'to',
    'settings_subtitle' => 'Configure system settings',

    // Users
    'add_user' => 'Add User',
    'edit_user' => 'Edit User',
    'create_user' => 'Create User',
    'delete_user' => 'Delete User',
    'user_info' => 'User Info',
    'user_details' => 'User Details',
    'no_users_found' => 'No users found.',
    'search_users' => 'Search users...',
    'user_role' => 'Role',
    'user_plan' => 'Plan',
    'user_joined' => 'Joined',
    'email_verified' => 'Email Verified',
    'mark_email_verified' => 'Mark email as verified',
    'role_admin' => 'Admin',
    'role_user' => 'User',
    'leave_blank_password' => 'Leave blank to keep current password',

    // Plans
    'add_plan' => 'Add Plan',
    'edit_plan' => 'Edit Plan',
    'create_plan' => 'Create Plan',
    'create_new_plan' => 'Create New Plan',
    'update_plan' => 'Update Plan',
    'delete_plan' => 'Delete Plan',
    'no_plans_found' => 'No plans found.',
    'plan_features' => 'Features',
    'plan_price' => 'Price',
    'plan_interval' => 'Billing Interval',
    'monthly' => 'Monthly',
    'yearly' => 'Yearly',
    'default_plan' => 'Default Plan',
    'mark_as_default' => 'Mark as default plan',
    'per_month' => '/month',
    'subscribers' => 'subscribers',
    'plan_name' => 'Plan Name',
    'plan_name_placeholder' => 'Pro',
    'basic_information' => 'Basic Information',
    'usage_limits' => 'Usage Limits',
    'monthly_build_credits' => 'Monthly Build Credits',
    'unlimited' => 'Unlimited',
    'appetize_preview' => 'Appetize Preview',
    'hosted_pages' => 'Hosted Pages',
    'ai_assistant' => 'AI Assistant',
    'allow_own_api_keys' => 'Allow own API keys',
    'permissions' => 'Permissions',
    'custom_css_js_injection' => 'Custom CSS/JS Injection',
    'api_access' => 'API Access',
    'builder_access' => 'Builder Access',
    'all_builders_allowed' => 'All builders allowed',
    'select_builders' => 'Select builders',
    'builders_selected' => ':count builder selected|:count builders selected',
    'allow_all_builders' => 'Allow All Builders',
    'search_builders_placeholder' => 'Search builders...',
    'features_pricing_display' => 'Features (Pricing Display)',
    'feature_name' => 'Feature name',
    'included' => 'Included',
    'not_included' => 'Not Included',
    'no_features_added' => 'No features added yet. Add features to display on pricing page.',

    // Subscriptions
    'add_subscription' => 'Add Subscription',
    'subscription_details' => 'Subscription Details',
    'no_subscriptions_found' => 'No subscriptions found.',
    'search_subscriptions' => 'Search subscriptions...',
    'renewal_date' => 'Renewal Date',
    'subscription_status' => 'Status',
    'change_plan' => 'Change Plan',
    'cancel_subscription' => 'Cancel Subscription',
    'next_billing' => 'Next Billing',
    'no_plan' => 'No Plan',
    'select_user' => 'Select a user',
    'select_plan' => 'Select a plan',
    'payment_method_placeholder' => 'Manual, Bank Transfer, etc.',

    // Transactions
    'transaction_details' => 'Transaction Details',
    'no_transactions_found' => 'No transactions found.',
    'search_transactions' => 'Search transactions...',
    'transaction_id' => 'ID',
    'transaction_date' => 'Date',
    'transaction_amount' => 'Amount',
    'payment_method' => 'Payment Method',
    'payment_gateway' => 'the payment gateway',
    'transaction_status' => 'Status',
    'approve' => 'Approve',
    'decline' => 'Decline',
    'confirm_approval' => 'Confirm Approval',
    'confirm_decline' => 'Confirm Decline',
    'approve_payment' => 'Approve Payment',
    'decline_payment' => 'Decline Payment',
    'approve_bank_transfer_confirm' => 'Are you sure you want to approve this bank transfer payment? This will activate the user\'s subscription.',
    'decline_bank_transfer_confirm' => 'Are you sure you want to decline this bank transfer payment? This will cancel the subscription and notify the user.',

    // Builders
    'add_builder' => 'Add Builder',
    'edit_builder' => 'Edit Builder',
    'create_builder' => 'Create Builder',
    'delete_builder' => 'Delete Builder',
    'no_builders_found' => 'No builders found.',
    'search_builders' => 'Search builders...',
    'builder_name' => 'Builder Name',
    'builder_url' => 'URL',
    'builder_status' => 'Status',
    'builder_platform' => 'Platform',
    'builder_platforms' => 'Platforms',
    'builder_name_placeholder' => 'Production Builder',
    'server_url_placeholder' => 'http://192.168.2.29',
    'server_key_placeholder' => 'Generated server key',
    'builder_queue' => 'Queue',
    'current_builds' => 'Current Builds',
    'total_builds' => 'Total Builds',
    'server_url' => 'Server URL',
    'port' => 'Port',
    'server_key' => 'Server Key',
    'server_key_help' => 'Used to authenticate API requests to this builder',
    'generate' => 'Generate',
    'max_queue' => 'Max Queue',
    'max_queue_help' => 'Maximum concurrent builds',
    'build_credit_cost' => 'Build Credit Cost',
    'credit_cost_help' => 'Credits deducted per build',
    'supported_platforms' => 'Supported Platforms',
    'select_platforms' => 'Select platforms',
    'platforms_selected' => ':count platform selected|:count platforms selected',
    'platforms_help' => 'Select one or more platforms this builder supports',
    'no_platforms_available' => 'No platforms available',
    'no_builders_configured' => 'No builders configured yet.',
    'default' => 'Default',
    'locked' => 'Locked',
    'from_purchase_code' => 'From purchase code',
    'purchase_code_not_set_warning' => 'Purchase code not configured',
    'purchase_code_not_set_description' => 'The default builder requires a valid purchase code. Please configure it in Settings > General.',
    'server_key_from_purchase_code_help' => 'Server key is automatically set from your purchase code.',

    // Plugins
    'upload_plugin' => 'Upload Plugin',
    'configure_plugin' => 'Configure',
    'delete_plugin' => 'Delete Plugin',
    'no_plugins_found' => 'No plugins found.',
    'plugin_name' => 'Name',
    'plugin_version' => 'Version',
    'plugin_type' => 'Type',
    'plugin_status' => 'Status',

    // Languages
    'add_language' => 'Add Language',
    'add_new_language' => 'Add New Language',
    'edit_language' => 'Edit Language',
    'create_language' => 'Create Language',
    'delete_language' => 'Delete Language',
    'no_languages_found' => 'No languages found.',
    'cannot_delete_default_language' => 'Cannot delete the default or primary language.',
    'default_language_badge' => 'Default',
    'language_name' => 'Language Name',
    'language_code' => 'Language Code',
    'language_code_help' => '2-letter ISO 639-1 code (e.g., en, es, fr)',
    'language_code_from_folder' => 'Select from available translation folders',
    'language_flag' => 'Flag',
    'language_flag_help' => 'Country flag emoji',
    'language_flag_auto' => 'Flag is automatically set based on language code',
    'language_flag_country_code_help' => '2-letter country code (e.g., us, gb, es)',
    'language_name_placeholder' => 'English',
    'language_code_placeholder' => 'en',
    'language_flag_placeholder' => '🇺🇸',
    'language_status' => 'Status',
    'rtl_support' => 'Text Direction',
    'rtl_enabled' => 'Right-to-Left (RTL)',
    'rtl_description' => 'Enable for languages like Arabic, Hebrew, Persian, and Urdu',
    'translation_files_created' => 'Translation files will be created at: lang/:code/',
    'translation_files_auto_created' => 'Ensure translation files exist in :path before adding this language. Copy the lang/en/ folder, rename it to your language code, and translate the contents.',

    // Email Templates
    'edit_template' => 'Edit Template',
    'edit_email_template' => 'Edit Email Template',
    'reset_template' => 'Reset to Default',
    'no_templates_found' => 'No templates found.',
    'template_subject' => 'Subject',
    'template_body' => 'Body',
    'template_variables' => 'Available Variables',
    'subject_line' => 'Subject Line',
    'email_subject_placeholder' => 'Email subject...',
    'email_body' => 'Email Body',
    'click_to_insert' => 'Click to insert at cursor position',
    'no_variables_available' => 'No variables available for this template.',
    'quick_tips' => 'Quick Tips',
    'variables_replaced' => 'Variables are replaced with real data when sent',
    'toolbar_format_tip' => 'Use the toolbar to format text, add links, and create lists',
    'link_tip' => 'Select text and click the link button to add clickable links',

    // Cronjobs
    'no_cronjobs_found' => 'No cron jobs found.',
    'no_cron_logs_found' => 'No cron logs found.',
    'search_logs' => 'Search logs...',
    'job_name' => 'Job Name',
    'job' => 'Job',
    'last_run' => 'Last Run',
    'next_run' => 'Next Run',
    'run_duration' => 'Duration',
    'started' => 'Started',
    'duration' => 'Duration',
    'triggered_by' => 'Triggered By',
    'message' => 'Message',
    'all_jobs' => 'All Jobs',
    'trigger_manually' => 'Trigger Manually',
    'status_success' => 'Success',
    'status_running' => 'Running',

    // Settings
    'general_settings' => 'General Settings',
    'email_settings' => 'Email Settings',
    'social_login_settings' => 'Social Login',
    'appetize_settings' => 'Appetize Settings',
    'ai_settings' => 'AI Settings',
    'gdpr_settings' => 'GDPR Settings',

    // General Settings Fields
    'site_name' => 'Site Name',
    'site_description' => 'Site Description',
    'site_tagline' => 'Site Tagline',
    'logo' => 'Logo',
    'logo_dark' => 'Dark Mode Logo',
    'favicon' => 'Favicon',
    'default_theme' => 'Default Theme',
    'landing_page_enabled' => 'Enable Landing Page',
    'system_currency' => 'System Currency',
    'default_language' => 'Default Language',
    'default_language_description' => 'Default language for new visitors and users without a preference',

    // Status Labels
    'status_active' => 'Active',
    'status_inactive' => 'Inactive',
    'status_pending' => 'Pending',
    'status_expired' => 'Expired',
    'status_cancelled' => 'Cancelled',
    'status_completed' => 'Completed',
    'status_failed' => 'Failed',

    // Demo Mode
    'demo_mode_notice' => 'Settings cannot be modified in demo mode.',
    'disabled_in_demo' => 'Disabled in demo mode',
    'hidden_in_demo' => 'Hidden in demo mode',

    // Plugins
    'plugins_title_full' => 'Plugins',
    'plugins_subtitle_full' => 'Extend functionality with custom plugins',
    'no_plugins_installed' => 'No plugins installed',
    'plugin_activate' => 'Activate',
    'plugin_deactivate' => 'Deactivate',
    'plugin_uninstall' => 'Uninstall',
    'plugin_author' => 'by :author',

    // Languages
    'languages_title_full' => 'Languages',
    'languages_subtitle_full' => 'Manage language translations and localization',

    // Cronjobs
    'cronjobs_title_full' => 'Cron Jobs',
    'cronjobs_tab_jobs' => 'Scheduled Jobs',
    'cronjobs_tab_logs' => 'Execution Logs',
    'execute_job' => 'Execute',
    'executing_job' => 'Executing...',

    // Email Settings
    'email_config_title' => 'Email Configuration',
    'email_config_subtitle' => 'Configure email settings and SMTP server',
    'mail_driver' => 'Mail Driver',
    'php_mail' => 'PHP Mail',
    'smtp' => 'SMTP',
    'php_mail_description' => 'PHP Mail uses your server\'s built-in mail configuration. Simple but may have deliverability issues on some servers.',
    'php_mail_warning' => 'Note: Some hosting providers disable PHP\'s mail() function. If emails aren\'t being sent, consider switching to SMTP.',
    'smtp_config' => 'SMTP Server Configuration',
    'smtp_host' => 'SMTP Host',
    'smtp_port' => 'SMTP Port',
    'smtp_username' => 'SMTP Username',
    'smtp_password' => 'SMTP Password',
    'smtp_encryption' => 'Encryption',
    'encryption_tls' => 'TLS',
    'encryption_ssl' => 'SSL',
    'encryption_none' => 'None',
    'admin_notifications' => 'Admin Notifications',
    'admin_email' => 'Admin Notification Email',
    'admin_email_help' => 'Email address to receive admin notifications. If empty, the logged-in admin\'s email will be used.',
    'notify_user_registered' => 'New user registered',
    'notify_subscription_created' => 'New subscription created',
    'notify_subscription_cancelled' => 'Subscription cancelled',
    'notify_payment_received' => 'Payment received',
    'notify_payment_failed' => 'Payment failed',
    'notify_build_started' => 'Build started',
    'notify_build_completed' => 'Build completed',
    'notify_build_failed' => 'Build failed',
    'test_email' => 'Test Email',
    'send_test_email' => 'Send Test Email',
    'sending' => 'Sending...',
    'mail_from_name' => 'Mail From Name',
    'mail_from_address' => 'Mail From Address',
    'php_mail_info' => 'PHP Mail uses your server\'s built-in mail configuration (sendmail/postfix). No additional setup required in this panel.',
    'php_mail_switch_warning' => 'Note: Some hosting providers disable PHP\'s mail() function. If emails fail to send, switch to SMTP.',
    'admin_notifications_subtitle' => 'Configure where admin payment notifications are sent',
    'admin_email_description' => 'Email address to receive admin notifications. Also used for test emails.',
    'notification_events' => 'Notification Events',
    'notification_events_description' => 'Select which events should trigger admin notifications',
    'event_subscription_activated' => 'Subscription Activated',
    'event_payment_completed' => 'Payment Completed',
    'event_payment_failed' => 'Payment Failed',
    'event_subscription_cancelled' => 'Subscription Cancelled',
    'event_subscription_expired' => 'Subscription Expired',
    'event_bank_transfer_pending' => 'Bank Transfer Pending',
    'event_user_registered' => 'User Registered',
    'event_build_completed' => 'Build Completed',
    'event_build_failed' => 'Build Failed',

    // Social Login Settings
    'auth_settings_title' => 'Authentication Settings',
    'auth_settings_subtitle' => 'Configure registration and social login options',
    'enable_registration' => 'Enable Registration',
    'enable_registration_description' => 'Allow new users to register accounts',
    'require_email_verification' => 'Require Email Verification',
    'require_email_verification_description' => 'When disabled, new registrations are automatically verified',
    'recaptcha_title' => 'reCAPTCHA v3',
    'recaptcha_description' => 'Protect authentication forms from bots',
    'recaptcha_site_key' => 'Site Key',
    'recaptcha_site_key_placeholder' => 'Your reCAPTCHA v3 Site Key',
    'recaptcha_secret_key' => 'Secret Key',
    'recaptcha_secret_key_placeholder' => 'Your reCAPTCHA v3 Secret Key',
    'leave_blank_keep_current' => 'Leave blank to keep current',
    'google_login' => 'Google',
    'facebook_login' => 'Facebook',
    'github_login' => 'GitHub',
    'client_id' => 'Client ID',
    'client_id_placeholder' => 'Your :provider Client ID',
    'client_secret' => 'Client Secret',
    'client_secret_placeholder' => 'Your :provider Client Secret',
    'app_id' => 'App ID',
    'app_id_placeholder' => 'Your :provider App ID',
    'app_secret' => 'App Secret',
    'app_secret_placeholder' => 'Your :provider App Secret',
    'callback_url' => 'Callback URL',
    'oauth_help' => 'Create OAuth credentials in the :provider Developer Console. Use the callback URL above.',
    'test_connection' => 'Test Connection',
    'testing' => 'Testing...',
    'configure_oauth' => 'Configure :provider OAuth credentials',
    'add_url_to_console' => 'Add this URL to your :provider',
    'leave_blank_keep_current' => 'Leave blank to keep current',
    'your_provider_key' => 'Your :provider :type',
    'recaptcha_help' => 'Get your keys from the :link. Make sure to select reCAPTCHA v3.',
    'recaptcha_console' => 'Google reCAPTCHA Admin Console',
    'get_api_key_from' => 'Get your API key from :link',

    // General Settings
    'general_settings_title' => 'General Settings',
    'general_settings_subtitle' => 'Update your site information and branding',
    'site_name_label' => 'Site Name',
    'site_description_label' => 'Site Description',
    'site_description_placeholder' => 'Used for meta description and SEO',
    'site_tagline_label' => 'Site Tagline',
    'site_tagline_placeholder' => 'Short tagline shown below logo',
    'site_tagline_help' => 'Displayed below the logo in sidebar and login pages',
    'purchase_code_label' => 'Purchase Code',
    'purchase_code_help' => 'Your license or purchase code for this installation (optional)',
    'logo_light' => 'Logo (Light Mode)',
    'logo_dark_label' => 'Logo (Dark Mode)',
    'delete_logo' => 'Delete Logo',
    'delete_dark_logo' => 'Delete Dark Logo',
    'delete_favicon' => 'Delete Favicon',
    'logo_help' => 'Recommended: 200x50px (horizontal) or 50x50px (square). PNG, JPG, SVG with transparent background. Max 2MB.',
    'favicon_label' => 'Favicon',
    'favicon_help' => 'Recommended: 32x32px or 16x16px. PNG, ICO, or SVG. Max 1MB.',
    'default_theme_label' => 'Default Color Theme',
    'theme_system' => 'System (Follow user\'s device preference)',
    'theme_light' => 'Light',
    'theme_dark' => 'Dark',
    'theme_help' => 'Default theme for new visitors. Users can change this in their settings.',
    'currency_label' => 'System Currency',
    'currency_help' => 'Currency used for all pricing and payments. This determines which payment gateways are available.',
    'landing_page_toggle' => 'Enable Public Landing Page',
    'landing_page_help' => 'When disabled, visitors accessing the root URL (/) will be redirected to the login page',

    // Plan Configuration Settings
    'plan_config_title' => 'Plan Configuration',
    'plan_config_subtitle' => 'Configure default plan settings for new users',
    'default_plan_label' => 'Default Plan',
    'default_plan_none' => 'None (require subscription)',
    'default_plan_help' => 'Plan assigned to new users upon registration. If no plan is selected, users will need to subscribe to access features.',

    // AI Settings
    'ai_settings_title' => 'AI Chat Assistant',
    'ai_settings_subtitle' => 'Configure AI-powered app creation assistant',
    'enable_ai' => 'Enable AI Chat Assistant',
    'enable_ai_description' => 'Allow users to create and configure apps via AI conversation',
    'enable_streaming' => 'Enable Streaming Responses',
    'enable_streaming_description' => 'Stream AI responses word-by-word for a more interactive experience',
    'streaming_warning' => 'May not work on all shared hosting environments',
    'ai_provider' => 'AI Provider',
    'ai_provider_help' => 'Choose between OpenAI (GPT-4.1) or Anthropic (Claude)',
    'api_key' => 'API Key',
    'enter_api_key' => 'Enter your API key',
    'openai_console' => 'OpenAI console',
    'anthropic_console' => 'Anthropic console',
    'api_key_help' => 'Get your API key from the :provider',
    'advanced_settings' => 'Advanced Settings',
    'ai_model' => 'AI Model',
    'ai_model_help' => 'Select the AI model to use for chat responses',
    'temperature' => 'Temperature',
    'temperature_help' => 'Controls randomness. Lower = more focused, Higher = more creative',
    'max_tokens' => 'Max Response Tokens',
    'max_tokens_help' => 'Maximum tokens per AI response. Higher values = longer responses but more cost',
    'auto_summarization' => 'Auto-Summarization',
    'enable_summarization' => 'Enable Auto-Summarization',
    'summarization_help' => 'Automatically summarize older messages to reduce token usage in long conversations',
    'summarization_threshold' => 'Summarization Threshold',
    'summarization_threshold_help' => 'Number of messages before auto-summarization triggers',
    'summarization_keep_recent' => 'Keep Recent Messages',
    'summarization_keep_recent_help' => 'Number of recent messages to keep',
    'summarization_max_length' => 'Max Summary Length',
    'summarization_max_length_help' => 'Maximum characters for summary',
    'chat_widget' => 'Chat Widget',
    'widget_position' => 'Widget Position',
    'position_bottom_right' => 'Bottom Right',
    'position_bottom_left' => 'Bottom Left',
    'position_top_right' => 'Top Right',
    'position_top_left' => 'Top Left',
    'position_help' => 'Where the AI chat widget appears on the app editor page',

    // GDPR Settings
    'gdpr_settings_title' => 'GDPR Settings',
    'gdpr_settings_subtitle' => 'Configure GDPR compliance and privacy settings',
    'enable_cookie_consent' => 'Enable Cookie Consent Banner',
    'enable_data_export' => 'Enable Data Export',
    'enable_account_deletion' => 'Enable Account Deletion',
    'deletion_grace_period' => 'Account Deletion Grace Period (days)',
    'audit_log_retention' => 'Audit Log Retention (days)',

    // Appetize Settings
    'appetize_settings_title' => 'Appetize Settings',
    'appetize_settings_subtitle' => 'Configure Appetize.io for live app previews',
    'appetize_api_token' => 'Appetize API Token',
    'appetize_api_token_help' => 'Get your API token from your Appetize.io dashboard',

    // Delete/Action Modal Messages
    'delete_user_confirm' => 'Are you sure you want to delete',
    'delete_builder_confirm' => 'Are you sure you want to delete',
    'delete_plan_confirm' => 'Are you sure you want to delete the',
    'delete_plan_confirm_suffix' => 'plan?',
    'delete_language_confirm' => 'Are you sure you want to delete',
    'delete_language_note' => 'This action cannot be undone. Translation files will be kept for data safety.',
    'uninstall_plugin' => 'Uninstall Plugin',
    'uninstall_plugin_confirm' => 'Are you sure you want to uninstall',
    'cancel_subscription_confirm' => 'Are you sure you want to cancel the subscription for',
    'reset_email_template' => 'Reset Email Template',
    'reset_template_confirm' => 'Are you sure you want to reset',
    'reset_template_confirm_suffix' => 'to its default content?',
    'reset_template_warning' => 'Any customizations you\'ve made will be lost.',
    'disabled_in_demo' => 'Disabled in demo mode',

    // Plugin Upload Modal
    'plugin_file' => 'Plugin File',
    'plugin_file_help' => 'ZIP file (MAX. 10MB)',
    'installing_plugin' => 'Installing plugin...',
    'installing' => 'Installing...',

    // Plugin Config Modal
    'configure_plugin_title' => 'Configure :name',
    'no_config_required' => 'No Configuration Required',
    'no_config_required_desc' => 'This plugin does not require any configuration.',

    // Appetize Settings Extended
    'appetize_integration_title' => 'Appetize.io Integration',
    'appetize_integration_subtitle' => 'Configure live app preview functionality',
    'enable_appetize_integration' => 'Enable Appetize.io Integration',
    'enable_appetize_description' => 'Allow users with Pro/Enterprise plans to preview apps in browser',
    'appetize_api_token_placeholder' => 'Enter your Appetize.io API token',
    'appetize_api_token_link' => 'Get your API token from',
    'auto_upload_builds' => 'Auto-upload builds to Appetize',
    'auto_upload_description' => 'Automatically upload successful builds for instant preview',
    'preview_retention_days' => 'Preview Retention (Days)',
    'preview_retention_help' => 'Delete old previews after this many days to save costs (1-30 days)',
    'session_timeout_seconds' => 'Session Timeout (Seconds)',
    'session_timeout_help' => 'Inactivity timeout before session ends',
    'seconds_30' => '30 seconds',
    'minute_1' => '1 minute',
    'minutes_2' => '2 minutes',
    'minutes_3' => '3 minutes',
    'minutes_5' => '5 minutes',
    'minutes_10' => '10 minutes',

    // GDPR Settings Extended
    'gdpr_privacy_settings_title' => 'GDPR & Privacy Settings',
    'gdpr_privacy_settings_subtitle' => 'Configure data protection and privacy compliance',
    'feature_toggles' => 'Feature Toggles',
    'cookie_consent_banner' => 'Cookie Consent Banner',
    'cookie_consent_description' => 'Show cookie consent banner to new visitors',
    'user_data_export' => 'User Data Export',
    'user_data_export_description' => 'Allow users to request a copy of their data',
    'user_account_deletion' => 'User Account Deletion',
    'user_account_deletion_description' => 'Allow users to request account deletion',
    'policy_versions' => 'Policy Versions',
    'policy_versions_help' => 'Updating policy versions will trigger re-consent for users.',
    'privacy_policy' => 'Privacy Policy',
    'terms_of_service' => 'Terms of Service',
    'cookie_policy' => 'Cookie Policy',
    'data_retention_periods' => 'Data Retention Periods (Days)',
    'retention_transactions' => 'Transactions',
    'retention_transactions_help' => 'Min 365 days (legal requirement)',
    'retention_inactive_accounts' => 'Inactive Accounts',
    'retention_expired_builds' => 'Expired Builds',
    'retention_audit_logs' => 'Audit Logs',
    'retention_data_exports' => 'Data Exports',
    'grace_periods_rate_limits' => 'Grace Periods & Rate Limits',
    'account_deletion_grace_period' => 'Account Deletion Grace Period (Days)',
    'account_deletion_grace_help' => 'Time before account is permanently deleted',
    'data_export_rate_limit' => 'Data Export Rate Limit (Hours)',
    'data_export_rate_limit_help' => 'Minimum time between export requests',

    // App/Plan Settings
    'plan_configuration' => 'Plan Configuration',
    'plan_configuration_subtitle' => 'Configure default plan settings for new users',
    'default_plan_option_none' => 'None (require subscription)',
    'default_plan_description' => 'Plan assigned to new users. Select "None" to require subscription before use.',

    // Overview Stats
    'overview_subtitle' => 'System-wide statistics and administration metrics',
    'date_range_today' => 'Today',
    'date_range_week' => 'Week',
    'date_range_month' => 'Month',
    'date_range_year' => 'Year',
    'date_range_all' => 'All Time',
    'auto_refresh' => 'Auto-Refresh',
    'total_system_users' => 'Total System Users',
    'active_subscriptions' => 'Active Subscriptions',
    'revenue_label' => ':period Revenue',
    'total_apps' => 'Total Apps',
    'vs_last_month' => 'vs last month',
    'total_builds_stat' => 'Total Builds',
    'completed_today' => 'Completed Today',
    'build_success_rate' => 'Build Success Rate',
    'pending_queue' => 'Pending Queue',
    'total_transactions' => 'Total Transactions',
    'active_plans' => 'Active Plans',
    'active_builders' => 'Active Builders',
    'revenue_trends' => 'Revenue Trends (12 Months)',
    'build_activity' => 'Build Activity (Last 30 Days)',
    'revenue_by_gateway' => 'Revenue by Payment Gateway',
    'no_revenue_data' => 'No revenue data available yet',
    'total_revenue' => 'Total Revenue',
    'platform_distribution' => 'Platform Distribution',
    'no_apps_created' => 'No apps created yet',
    'pending_payments' => 'Pending Payments',
    'active_users_7d' => 'Active Users (7d)',
    'notifications_today' => 'Notifications (Today)',
    'build_performance_by_platform' => 'Build Performance by Platform',
    'platform' => 'Platform',
    'completed' => 'Completed',
    'failed' => 'Failed',
    'success_rate' => 'Success Rate',
    'avg_duration' => 'Avg Duration',
    'revenue_label_short' => 'Revenue',
    'builds_label' => 'Builds',
    'recent_user_registrations' => 'Recent User Registrations',
    'no_users_yet' => 'No users yet',
    'recent_builds' => 'Recent Builds',
    'no_builds_yet' => 'No builds yet',
    'recent_transactions' => 'Recent Transactions',
    'no_transactions_yet' => 'No transactions yet',

    // Cronjobs Manager
    'cronjobs_tab_scheduled' => 'Jobs',
    'cronjobs_tab_execution_logs' => 'Execution Logs',

    // Payment Gateway Configuration
    'payment_gateways' => [
        // Common
        'api_credentials' => 'API Credentials',
        'webhook_configuration' => 'Webhook Configuration',
        'webhook_url' => 'Webhook URL',
        'copy' => 'Copy',
        'copied' => 'Copied!',
        'copy_failed' => 'Failed to copy. Please manually select and copy the URL.',
        'required_webhook_events' => 'Required Webhook Events',
        'features' => 'Features',
        'supported_features' => 'Supported Features',
        'secret_key' => 'Secret Key',
        'webhook_secret' => 'Webhook Secret',
        'webhook_signing_secret' => 'Webhook Signing Secret',
        'optional' => 'Optional',

        // SSL Warning
        'ssl_warning' => 'Warning:',
        'ssl_warning_stripe' => 'Your site is not using HTTPS. Stripe requires HTTPS for webhooks and production usage.',
        'ssl_warning_paypal' => 'Your site is not using HTTPS. PayPal webhooks require a secure HTTPS connection. Please enable SSL/TLS before going live.',
        'ssl_warning_paystack' => 'Your site is not using HTTPS. Paystack webhooks require a secure HTTPS connection. Please enable SSL/TLS before going live.',

        // Stripe
        'stripe' => [
            'get_started' => 'Get Started with Stripe',
            'get_api_keys' => 'Get your API keys from',
            'dashboard_link' => 'Stripe Dashboard → Developers → API Keys',
            'secret_key_placeholder' => 'sk_live_...',
            'secret_key_help' => 'Use test key (sk_test_) for testing, live key (sk_live_) for production',
            'webhook_url_help' => 'Add this URL in Stripe Dashboard → Developers → Webhooks',
            'webhook_secret_placeholder' => 'whsec_...',
            'webhook_secret_help' => 'Get this after creating webhook endpoint in Stripe Dashboard',
            'events_help' => 'Select these events when creating your webhook endpoint:',
            'feature_currencies' => '135+ currencies supported globally',
            'feature_intervals' => 'All billing intervals supported',
            'feature_renewal' => 'Automatic subscription renewal',
            'feature_customer_management' => 'Customer management',
            'feature_signature_verification' => 'Webhook signature verification',
            'feature_refund' => 'Refund handling',
            'feature_sca' => 'Strong Customer Authentication (SCA) compliant',
        ],

        // PayPal
        'paypal' => [
            'client_id' => 'Client ID',
            'client_id_help' => 'Get this from PayPal Developer Dashboard',
            'client_secret' => 'Client Secret',
            'client_secret_help' => 'Keep this secret and never share it publicly',
            'sandbox_mode' => 'Sandbox Mode',
            'sandbox_mode_help' => 'Enable for testing with PayPal Sandbox. Disable for live transactions.',
            'webhook_url_help' => 'Add this URL to your PayPal webhook settings',
            'webhook_id' => 'Webhook ID',
            'webhook_id_help' => 'Webhook ID from PayPal Dashboard for signature verification (required for security)',
            'events_help' => 'Make sure to enable these events in your PayPal webhook configuration:',
        ],

        // Razorpay
        'razorpay' => [
            'get_started' => 'Get Started with Razorpay',
            'get_api_keys' => 'Get your API keys from',
            'dashboard_link' => 'Razorpay Dashboard → Settings → API Keys',
            'key_id' => 'Key ID',
            'key_id_placeholder' => 'rzp_live_...',
            'key_id_help' => 'Use test key (rzp_test_) for testing, live key (rzp_live_) for production',
            'key_secret' => 'Key Secret',
            'key_secret_help' => 'Keep this secret and never share it publicly',
            'webhook_url_help' => 'Add this URL in Razorpay Dashboard → Settings → Webhooks',
            'webhook_secret_placeholder' => 'Enter webhook secret',
            'webhook_secret_help' => 'Get this from Razorpay Dashboard after creating webhook',
            'events_help' => 'Enable these events in Razorpay Dashboard → Settings → Webhooks:',
            'feature_currencies' => '100+ currencies supported',
            'feature_intervals' => 'All billing intervals (daily, weekly, monthly, yearly)',
            'feature_payment_methods' => 'UPI, Cards, NetBanking, Wallets, EMI',
            'feature_renewal' => 'Automatic subscription renewal',
            'feature_signature_verification' => 'Webhook signature verification',
            'feature_refund' => 'Refund handling',
            'feature_decimal' => 'Three-decimal currency support (KWD, BHD, etc.)',
        ],

        // Paystack
        'paystack' => [
            'get_started' => 'Get Started with Paystack',
            'get_api_keys' => 'Get your API keys from',
            'dashboard_link' => 'Paystack Dashboard → Settings → API Keys & Webhooks',
            'secret_key_help' => 'Get this from Paystack Dashboard (use test key for testing, live key for production)',
            'webhook_url_help' => 'Add this URL to your Paystack webhook settings',
            'webhook_secret_help' => 'Optional: For webhook signature verification (recommended for production)',
            'webhook_secret_placeholder' => 'Leave empty to skip signature verification',
            'events_help' => 'Enable these events in Paystack Dashboard → Settings → API Keys & Webhooks:',
            'feature_currencies' => 'Currencies: NGN, USD, GHS, ZAR, KES',
            'feature_intervals' => 'Intervals: Daily, Weekly, Monthly (1, 3, 6 months), Yearly',
            'feature_renewal' => 'Automatic subscription renewal',
            'feature_signature_verification' => 'Webhook signature verification',
            'feature_interval_limitation' => 'Limited interval support (see documentation)',
        ],

        // Crypto.com
        'cryptocom' => [
            'get_started' => 'Get Started with Crypto.com Pay',
            'get_api_keys' => 'Get your API credentials from',
            'dashboard_link' => 'Crypto.com Pay Dashboard',
            'monthly_only_title' => 'Monthly Intervals Only',
            'monthly_only_description' => 'Crypto.com Pay currently supports monthly billing intervals only. Daily, weekly, and yearly subscriptions are not supported.',
            'secret_key_placeholder' => 'Enter your Crypto.com Pay secret key',
            'secret_key_help' => 'Get this from Crypto.com Pay Dashboard',
            'webhook_url_help' => 'Add this URL to your Crypto.com Pay webhook settings',
            'webhook_secret_placeholder' => 'Enter webhook signing secret',
            'webhook_secret_help' => 'Required for webhook signature verification',
            'events_help' => 'Enable these events in Crypto.com Pay Dashboard:',
            'feature_crypto_fiat' => 'Accept cryptocurrency and fiat payments',
            'feature_currencies' => '30+ supported currencies',
            'feature_renewal' => 'Automatic subscription renewal',
            'feature_signature_verification' => 'HMAC SHA-256 webhook signature verification',
            'feature_monthly_only' => 'Monthly intervals only (daily/weekly/yearly not supported)',
        ],

        // Bank Transfer
        'bank_transfer' => [
            'manual_approval_title' => 'Manual Approval Required',
            'manual_approval_description' => 'Bank transfer payments require manual verification. Users will see the instructions below after initiating payment. Admins must approve or decline payments at',
            'transactions_link' => 'Transactions',
            'instructions_title' => 'Bank Transfer Instructions',
            'instructions_label' => 'Instructions for Users',
            'instructions_placeholder' => "Enter your bank account details and transfer instructions here...\n\nExample:\n\nBank Name: ABC Bank\nAccount Name: Your Company Name\nAccount Number: 123456789\nSwift Code: ABCDEFGH\nReference: [User will see their subscription ID]\n\nPlease include your subscription ID in the payment reference and email proof of payment to billing@yourcompany.com",
            'instructions_help' => 'These instructions will be displayed to users after they select a plan. Include bank account details, reference format, and any verification steps.',
            'workflow_title' => 'How Bank Transfer Payments Work:',
            'workflow_step_1' => 'User selects a plan and chooses Bank Transfer as payment method',
            'workflow_step_2' => 'A pending subscription and transaction are created',
            'workflow_step_3' => 'User sees the instructions you configured above',
            'workflow_step_4' => 'User completes the bank transfer manually',
            'workflow_step_5' => 'Admin receives notification of pending payment',
            'workflow_step_6' => 'Admin approves payment → subscription activated and credits refilled',
            'workflow_step_7' => 'Admin declines payment → subscription and transaction removed',
            'feature_currencies' => 'All currencies supported',
            'feature_intervals' => 'All billing intervals supported (daily, weekly, monthly, yearly)',
            'feature_simple_setup' => 'Simple setup - no API credentials required',
            'feature_manual_verification' => 'Manual verification for security',
            'feature_no_fees' => 'No transaction fees or third-party dependency',
            'feature_admin_approval' => 'Requires admin approval for each payment',
            'feature_no_renewal' => 'No automatic subscription renewal',
        ],
    ],

    // Plan Features (dynamic)
    'feature_unlimited_build_credits' => 'Unlimited build credits',
    'feature_build_credits' => ':count build credits',
    'feature_all_builders' => 'Access to all active builders',
    'feature_builder_access' => 'Builder access',
    'feature_single_builder' => 'Access to single builder',
    'feature_multiple_builders' => 'Access to :count builders',
    'feature_custom_code' => 'Custom CSS/JS injection',
    'feature_api_access' => 'API Access',
    'feature_unlimited_hosted_pages' => 'Unlimited hosted pages',
    'feature_hosted_pages' => ':count hosted pages per app',
    'feature_hosted_pages_disabled' => 'Hosted pages',
    'feature_unlimited_ai_chat' => 'Unlimited AI Chat',
    'feature_ai_tokens' => ':count AI tokens/month',
    'feature_own_ai_key' => 'Use your own AI API key',
    'feature_ai_chat' => 'AI Chat Assistant',

    // Impersonation
    'impersonate' => 'Impersonate',
    'impersonate_user' => 'Impersonate User',
    'impersonation_started' => 'Now impersonating :name',
    'impersonation_stopped' => 'Impersonation ended. Welcome back!',
    'impersonating_as' => 'Viewing as :name',
    'exit_impersonation' => 'Exit',
    'return_to_admin' => 'Return to Admin',
    'not_impersonating' => 'Not currently impersonating any user.',
    'admin_blocked_during_impersonation' => 'Admin area is blocked while impersonating. Exit impersonation first.',
    'impersonation_disabled_demo' => 'Impersonation is disabled in demo mode.',
    'only_admins_can_impersonate' => 'Only administrators can impersonate users.',
];
