<div class="bg-white border border-gray-200 rounded-lg shadow-xs dark:bg-gray-800 dark:border-gray-700">
    <div class="p-6 border-b border-gray-200 dark:border-gray-700">
        <h3 class="text-lg font-semibold text-gray-900 dark:text-white">{{ __('admin.gdpr_privacy_settings_title') }}</h3>
        <p class="text-sm text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.gdpr_privacy_settings_subtitle') }}</p>
    </div>

    <form wire:submit="save" class="p-6 space-y-6">
        {{-- Feature Toggles --}}
        <div class="border-b border-gray-200 dark:border-gray-700 pb-6">
            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-4">{{ __('admin.feature_toggles') }}</h4>
            <div class="space-y-4">
                <label class="flex items-center gap-3">
                    <input type="checkbox" wire:model="cookieConsentEnabled" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                    <div>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.cookie_consent_banner') }}</span>
                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ __('admin.cookie_consent_description') }}</p>
                    </div>
                </label>

                <label class="flex items-center gap-3">
                    <input type="checkbox" wire:model="dataExportEnabled" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                    <div>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.user_data_export') }}</span>
                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ __('admin.user_data_export_description') }}</p>
                    </div>
                </label>

                <label class="flex items-center gap-3">
                    <input type="checkbox" wire:model="accountDeletionEnabled" class="w-4 h-4 text-blue-600 bg-gray-100 border-gray-300 rounded focus:ring-blue-500 dark:bg-gray-700 dark:border-gray-600">
                    <div>
                        <span class="text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.user_account_deletion') }}</span>
                        <p class="text-xs text-gray-500 dark:text-gray-400">{{ __('admin.user_account_deletion_description') }}</p>
                    </div>
                </label>
            </div>
        </div>

        {{-- Policy Versions --}}
        <div class="border-b border-gray-200 dark:border-gray-700 pb-6">
            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-4">{{ __('admin.policy_versions') }}</h4>
            <p class="text-xs text-gray-500 dark:text-gray-400 mb-4">{{ __('admin.policy_versions_help') }}</p>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.privacy_policy') }}</label>
                    <input type="text" wire:model="privacyPolicyVersion" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('privacyPolicyVersion') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.terms_of_service') }}</label>
                    <input type="text" wire:model="termsPolicyVersion" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('termsPolicyVersion') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.cookie_policy') }}</label>
                    <input type="text" wire:model="cookiePolicyVersion" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('cookiePolicyVersion') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
            </div>
        </div>

        {{-- Data Retention --}}
        <div class="border-b border-gray-200 dark:border-gray-700 pb-6">
            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-4">{{ __('admin.data_retention_periods') }}</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4">
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.retention_transactions') }}</label>
                    <input type="number" wire:model="retentionTransactions" min="365" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.retention_transactions_help') }}</p>
                    @error('retentionTransactions') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.retention_inactive_accounts') }}</label>
                    <input type="number" wire:model="retentionInactiveAccounts" min="30" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('retentionInactiveAccounts') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.retention_expired_builds') }}</label>
                    <input type="number" wire:model="retentionExpiredBuilds" min="7" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('retentionExpiredBuilds') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.retention_audit_logs') }}</label>
                    <input type="number" wire:model="retentionAuditLogs" min="30" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('retentionAuditLogs') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.retention_data_exports') }}</label>
                    <input type="number" wire:model="retentionDataExports" min="1" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    @error('retentionDataExports') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
            </div>
        </div>

        {{-- Grace Periods --}}
        <div class="pb-6">
            <h4 class="text-sm font-medium text-gray-900 dark:text-white mb-4">{{ __('admin.grace_periods_rate_limits') }}</h4>
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.account_deletion_grace_period') }}</label>
                    <input type="number" wire:model="accountDeletionGraceDays" min="1" max="30" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.account_deletion_grace_help') }}</p>
                    @error('accountDeletionGraceDays') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
                <div>
                    <label class="block mb-2 text-sm font-medium text-gray-900 dark:text-white">{{ __('admin.data_export_rate_limit') }}</label>
                    <input type="number" wire:model="dataExportRateLimitHours" min="1" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5 dark:bg-gray-700 dark:border-gray-600 dark:text-white">
                    <p class="text-xs text-gray-500 dark:text-gray-400 mt-1">{{ __('admin.data_export_rate_limit_help') }}</p>
                    @error('dataExportRateLimitHours') <span class="text-xs text-red-500">{{ $message }}</span> @enderror
                </div>
            </div>
        </div>

        @if(config('app.demo'))
            <button type="button" disabled title="{{ __('admin.disabled_in_demo') }}" class="text-white bg-blue-700 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 cursor-not-allowed opacity-50">
                {{ __('common.save') }}
            </button>
        @else
            <button type="submit" class="text-white bg-blue-700 hover:bg-blue-800 focus:ring-4 focus:ring-blue-300 font-medium rounded-lg text-sm px-5 py-2.5 dark:bg-blue-600 dark:hover:bg-blue-700 focus:outline-hidden dark:focus:ring-blue-800">
                {{ __('common.save') }}
            </button>
        @endif
    </form>
</div>
