<div class="relative" x-data="{ open: false }">
    @php
        $current = $languages->firstWhere('code', $currentLocale);
    @endphp

    <button
        @click="open = !open"
        type="button"
        class="flex items-center gap-2 px-2.5 py-2 text-sm font-medium text-gray-500 dark:text-gray-400 hover:bg-gray-100 dark:hover:bg-gray-700 rounded-lg focus:outline-none focus:ring-2 focus:ring-gray-200 dark:focus:ring-gray-600 transition-colors"
        title="{{ __('user.language_preference') }}"
    >
        @if($current?->flag)
            <span class="fi fi-{{ strtolower($current->flag) }} fis rounded-sm"></span>
        @else
            <span class="text-lg leading-none">🌐</span>
        @endif
        <svg class="w-3 h-3 transition-transform" :class="{ 'rotate-180': open }" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"/>
        </svg>
    </button>

    <div
        x-show="open"
        @click.away="open = false"
        x-transition:enter="transition ease-out duration-100"
        x-transition:enter-start="transform opacity-0 scale-95"
        x-transition:enter-end="transform opacity-100 scale-100"
        x-transition:leave="transition ease-in duration-75"
        x-transition:leave-start="transform opacity-100 scale-100"
        x-transition:leave-end="transform opacity-0 scale-95"
        x-cloak
        class="absolute w-48 bg-white dark:bg-gray-800 rounded-lg shadow-lg border border-gray-200 dark:border-gray-700 z-50 {{ $dropUp ? 'bottom-full mb-2' : 'top-full mt-2' }} {{ $alignStart ? 'ltr:left-0 rtl:right-0' : 'ltr:right-0 rtl:left-0' }}"
    >
        <ul class="py-2 max-h-64 overflow-y-auto">
            @forelse($languages as $language)
                <li>
                    <button
                        wire:click="setLocale('{{ $language->code }}')"
                        class="w-full flex items-center gap-3 px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700 transition-colors {{ $currentLocale === $language->code ? 'bg-blue-50 dark:bg-blue-900/20 text-blue-600 dark:text-blue-400' : '' }}"
                    >
                        <span class="fi fi-{{ strtolower($language->flag) }} fis rounded-sm"></span>
                        <span class="flex-1 text-start">{{ $language->name }}</span>
                        @if($currentLocale === $language->code)
                            <svg class="w-4 h-4 text-blue-600 dark:text-blue-400" fill="currentColor" viewBox="0 0 20 20">
                                <path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/>
                            </svg>
                        @endif
                    </button>
                </li>
            @empty
                <li class="px-4 py-2 text-sm text-gray-500 dark:text-gray-400">
                    {{ __('admin.no_languages_found') }}
                </li>
            @endforelse
        </ul>
    </div>
</div>
