@extends('upgrade.layout')

@section('header')
    <div class="flex items-center">
        <div class="flex-shrink-0">
            <div class="w-12 h-12 bg-blue-100 dark:bg-blue-900/30 rounded-full flex items-center justify-center">
                <svg class="w-6 h-6 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
            </div>
        </div>
        <div class="ml-4">
            <h1 class="text-xl font-semibold text-gray-900 dark:text-white">
                Database Upgrade Required
            </h1>
            <p class="mt-1 text-sm text-gray-500 dark:text-gray-400">
                {{ count($pendingMigrations) }} pending migration{{ count($pendingMigrations) !== 1 ? 's' : '' }} detected
            </p>
        </div>
    </div>
@endsection

@section('content')
    <!-- Warning Box -->
    <div class="p-4 mb-6 bg-yellow-50 dark:bg-yellow-900/20 border border-yellow-200 dark:border-yellow-800 rounded-lg">
        <div class="flex">
            <svg class="w-5 h-5 text-yellow-600 dark:text-yellow-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"></path>
            </svg>
            <div class="ml-3">
                <p class="text-sm text-yellow-700 dark:text-yellow-300">
                    <strong>Important:</strong> Back up your database before proceeding. This process will modify your database schema.
                </p>
            </div>
        </div>
    </div>

    <!-- Migrations List -->
    <div class="mb-6">
        <h3 class="text-sm font-medium text-gray-700 dark:text-gray-300 mb-3">Pending Migrations</h3>
        <div class="bg-gray-50 dark:bg-gray-700/50 rounded-lg border border-gray-200 dark:border-gray-600 overflow-hidden">
            <div class="max-h-64 overflow-y-auto">
                <table class="w-full text-sm">
                    <tbody class="divide-y divide-gray-200 dark:divide-gray-600">
                        @foreach($pendingMigrations as $migration)
                        <tr>
                            <td class="px-4 py-3 font-mono text-xs text-gray-600 dark:text-gray-300">
                                {{ $migration }}
                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Info Box -->
    <div class="p-4 bg-blue-50 dark:bg-blue-900/20 border border-blue-200 dark:border-blue-800 rounded-lg">
        <div class="flex">
            <svg class="w-5 h-5 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="currentColor" viewBox="0 0 20 20">
                <path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7-4a1 1 0 11-2 0 1 1 0 012 0zM9 9a1 1 0 000 2v3a1 1 0 001 1h1a1 1 0 100-2v-3a1 1 0 00-1-1H9z" clip-rule="evenodd"></path>
            </svg>
            <div class="ml-3">
                <p class="text-sm text-blue-700 dark:text-blue-300">
                    The upgrade process will run database migrations and clear application caches. This may take a moment.
                </p>
            </div>
        </div>
    </div>
@endsection

@section('footer')
    <form action="{{ route('upgrade.run') }}" method="POST" id="upgrade-form">
        @csrf
        <div class="flex justify-end">
            <button type="submit"
                    id="upgrade-button"
                    class="inline-flex items-center px-6 py-3 bg-blue-600 hover:bg-blue-700 text-white font-medium rounded-lg transition-colors focus:outline-none focus:ring-4 focus:ring-blue-300 dark:focus:ring-blue-800">
                <svg class="w-5 h-5 mr-2" id="upgrade-icon" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
                <svg class="w-5 h-5 mr-2 animate-spin hidden" id="upgrade-spinner" fill="none" viewBox="0 0 24 24">
                    <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                    <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                </svg>
                <span id="upgrade-text">Run Upgrade</span>
            </button>
        </div>
    </form>

    <script>
        document.getElementById('upgrade-form').addEventListener('submit', function() {
            var button = document.getElementById('upgrade-button');
            var icon = document.getElementById('upgrade-icon');
            var spinner = document.getElementById('upgrade-spinner');
            var text = document.getElementById('upgrade-text');

            button.disabled = true;
            button.classList.add('opacity-75', 'cursor-not-allowed');
            icon.classList.add('hidden');
            spinner.classList.remove('hidden');
            text.textContent = 'Upgrading...';
        });
    </script>
@endsection
